/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class VWOperatorComboBoxRenderer
extends DefaultListCellRenderer
implements TableCellRenderer {
    public static final int OPERATOR_EQUAL = 0;
    public static final int OPERATOR_NOT_EQUAL = 1;
    public static final int OPERATOR_GREATER_THAN = 2;
    public static final int OPERATOR_GREATER_THAN_OR_EQUAL = 3;
    public static final int OPERATOR_LESS_THAN = 4;
    public static final int OPERATOR_LESS_THAN_OR_EQUAL = 5;
    public static final int OPERATOR_LIKE = 6;
    public static final int OPERATOR_NOT_LIKE = 7;
    public static final int OPERATOR_NULL = 8;
    public static final int OPERATOR_NOT_NULL = 9;
    protected static final Border BORDER_NO_FOCUS = new EmptyBorder(1, 1, 1, 1);
    protected static final Border BORDER_INSETS = new EmptyBorder(new Insets(5, 5, 5, 5));

    public VWOperatorComboBoxRenderer() {
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
    }

    public static DefaultComboBoxModel getComboBoxModel(int nFieldType, boolean bIncludeNullOperators) {
        DefaultComboBoxModel<Integer> cbModel = new DefaultComboBoxModel<Integer>();
        switch (nFieldType) {
            case 2: {
                cbModel.addElement(new Integer(0));
                cbModel.addElement(new Integer(1));
                cbModel.addElement(new Integer(2));
                cbModel.addElement(new Integer(3));
                cbModel.addElement(new Integer(4));
                cbModel.addElement(new Integer(5));
                cbModel.addElement(new Integer(6));
                cbModel.addElement(new Integer(7));
                if (!bIncludeNullOperators) break;
                cbModel.addElement(new Integer(8));
                cbModel.addElement(new Integer(9));
                break;
            }
            case 4: {
                cbModel.addElement(new Integer(0));
                cbModel.addElement(new Integer(1));
                break;
            }
            default: {
                cbModel.addElement(new Integer(0));
                cbModel.addElement(new Integer(1));
                cbModel.addElement(new Integer(2));
                cbModel.addElement(new Integer(3));
                cbModel.addElement(new Integer(4));
                cbModel.addElement(new Integer(5));
            }
        }
        return cbModel;
    }

    public static String convertToSQLOperator(int nOperator) {
        switch (nOperator) {
            case 0: {
                return "=";
            }
            case 1: {
                return "<>";
            }
            case 2: {
                return ">";
            }
            case 3: {
                return ">=";
            }
            case 4: {
                return "<";
            }
            case 5: {
                return "<=";
            }
            case 6: {
                return "like";
            }
            case 7: {
                return "not like";
            }
            case 8: {
                return "is null";
            }
            case 9: {
                return "is not null";
            }
        }
        return null;
    }

    public Component getListCellRendererComponent(JList list, Object value, int nIndex, boolean isSelected, boolean cellHasFocus) {
        Component component = super.getListCellRendererComponent((JList<?>)list, value, nIndex, isSelected, cellHasFocus);
        String text = VWResource.s_selectAnOperator;
        component.setComponentOrientation(list.getComponentOrientation());
        if (value != null && value instanceof Integer) {
            int type = (Integer)value;
            text = this.typeToString(type);
        }
        ((JLabel)component).setText(text);
        ((JLabel)component).setToolTipText(text);
        return component;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(new CompoundBorder(border, BORDER_INSETS));
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    this.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    this.setBackground(col);
                }
            }
        } else {
            this.setBorder(new CompoundBorder(BORDER_NO_FOCUS, BORDER_INSETS));
        }
        if (value != null) {
            if (value instanceof Integer) {
                this.setText(this.typeToString((Integer)value));
            } else {
                this.setText(value.toString());
            }
        } else {
            this.setText(VWResource.s_selectAnOperator);
        }
        return this;
    }

    private String typeToString(int nType) {
        switch (nType) {
            case 0: {
                return VWResource.s_isEqualOp;
            }
            case 1: {
                return VWResource.s_notEqualOp;
            }
            case 2: {
                return VWResource.s_isGreaterThanOp;
            }
            case 3: {
                return VWResource.s_isGreaterThanOrEqualOp;
            }
            case 4: {
                return VWResource.s_isLessThanOp;
            }
            case 5: {
                return VWResource.s_isLessThanOrEqualOp;
            }
            case 6: {
                return VWResource.s_likeOp;
            }
            case 7: {
                return VWResource.s_notLikeOp;
            }
            case 8: {
                return VWResource.s_isNullOp;
            }
            case 9: {
                return VWResource.s_isNotNullOp;
            }
        }
        return null;
    }
}

